/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jnbt;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.Tag;
import java.util.Locale;

public class LongArrayTag
extends Tag {
    private final long[] value;

    public LongArrayTag(long[] value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public long[] getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder hex = new StringBuilder();
        for (long b : this.value) {
            String hexDigits = Long.toHexString(b).toUpperCase(Locale.ROOT);
            if (hexDigits.length() == 1) {
                hex.append("0");
            }
            hex.append(hexDigits).append(" ");
        }
        return "TAG_Long_Array(" + hex + ")";
    }
}

